import pygame, sys, random
from pygame.locals import *
import math


WINDOWWIDTH = 640
WINDOWHEIGHT = 480
BASICFONTSIZE = 20
WHITE = (255, 255, 255)

def check_distance(point1, point2):
    dist = math.sqrt((point1[0]-point2[0])**2 + (point1[1] - point2[1])**2)
    return dist

def image_center(image, pos):
    rect = image.get_rect()
    return (rect.center[0] + pos[0], rect.center[1] + pos[1])


def main():
    pygame.init()

    # Set Caption, font type and font size.
    display_surface = pygame.display.set_mode((WINDOWWIDTH, WINDOWHEIGHT))
    pygame.display.set_caption('Catching Butterfly')
    BASICFONT = pygame.font.Font('freesansbold.ttf', BASICFONTSIZE)

    # load background image and scale it to the size of the window.
    image = pygame.image.load(r'Image\walkway.jpg')
    image = pygame.transform.scale(image, (WINDOWWIDTH, WINDOWHEIGHT))

    # add 8 butterfly images and store them in a list.
    butterfly_images = []
    for i in range (1, 9):
        # Python 3 has used format function to replace the above %s formatting method
        butterfly_image = pygame.image.load(r'Image\butterfly\{}.png'.format(i))
        butterfly_image.convert()
        #butterfly_image = pygame.transform.scale(butterfly_image, (50, 50))
        butterfly_image = pygame.transform.rotozoom(butterfly_image, random.randint(-50, 50), 0.15)
        butterfly_images.append(butterfly_image)

    butterfly_x = 0
    butterfly_y = int(WINDOWHEIGHT/2)

    # specify the frame change frequency.
    FPS = 30
    fpsClock = pygame.time.Clock()

    # load butterfly net image and win image.
    net_image = pygame.image.load(r'Image\net.png')
    net_image = pygame.transform.scale(net_image, (150, 150))
    win_image = pygame.image.load(r'Image\win.png')
    win_image = pygame.transform.scale(win_image, (200, 200))
    mousex = 0
    mousey = 0

    # load background music.
    soundObj = pygame.mixer.Sound(r'Music\background_music.mp3')
    soundObj.play(-1, 0 ,0)

    # start main loop
    k = 0
    while True:
        mouseClicked = False
        display_surface.fill(WHITE)
        # specify the butterfly flying path
        if butterfly_x < WINDOWWIDTH:
            butterfly_x += random.randint(5, 10)
            if butterfly_y > 0 and butterfly_y < int(WINDOWHEIGHT*0.8):
                butterfly_y += random.randint(-25, 25)
            elif butterfly_y <= 0:
                butterfly_y += 10
            elif butterfly_y >= int(WINDOWHEIGHT * 0.8):
                butterfly_y -= 5
        else:
            butterfly_x = 0
            butterfly_y = int(WINDOWHEIGHT/2)

        # event loop to catch the keyboard and mouse events.
        for event in pygame.event.get():
            if event.type == QUIT:
                soundObj.stop()
                pygame.quit()
                sys.exit()
            elif event.type == MOUSEMOTION:
                mousex, mousey = event.pos
            elif event.type == MOUSEBUTTONUP:
                mousex, mousey = event.pos
                mouseClicked = True

        # blit the images to the display surface.
        net_point = (mousex - 75, mousey - 75)
        display_surface.blit(image, (0, 0))
        display_surface.blit(butterfly_images[k % 8], (butterfly_x, butterfly_y))
        display_surface.blit(net_image, net_point)

        '''based on the position of butterfly and net, check if the net catches
        the butterfly.
        If it does, show win image and update display surface.
        wait for 4 seconds and stop the program.'''
        if mouseClicked:
            catch_point = image_center(net_image, net_point)
            butterfly_point = image_center(butterfly_images[k % 8], \
            (butterfly_x, butterfly_y))
            if check_distance(catch_point, butterfly_point) < 60:
                display_surface.blit(win_image, (int(WINDOWWIDTH/2), int(WINDOWHEIGHT/2)))
                pygame.display.update()
                pygame.time.wait(4000)
                pygame.quit()
                sys.exit()

        k += 1
        pygame.display.update()
        fpsClock.tick(FPS)

if __name__ == '__main__':
    main()
